/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.ztijwthelper;

import java.io.IOException;
import java.time.Duration;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.DefaultJwtSource;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.JwtSource;
import org.byted.security.ztijwthelper.ZtiJwtException;

class JwtSourceFactory {
    private static final String defaultAgentSocketAddress = "unix:/var/run/zti-agent.sock";
    private static final long defaultTimeoutMillis = 5000L;
    private static volatile JwtSource jwtSource;
    private static volatile String agentSocketAddress;

    private JwtSourceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JwtSource getJwtSource(String agentSocketFile) throws ZtiJwtException {
        Class<JwtSourceFactory> clazz = JwtSourceFactory.class;
        synchronized (JwtSourceFactory.class) {
            String agentSocketAddr = JwtSourceFactory.getAgentSocketAddress(agentSocketFile);
            if (jwtSource == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return JwtSourceFactory.newJwtSource(agentSocketAddr);
            }
            if (!agentSocketAddr.equals(agentSocketAddress)) {
                try {
                    jwtSource.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return JwtSourceFactory.newJwtSource(agentSocketAddr);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jwtSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JwtSource newJwtSource(String agentSocketAddr) throws ZtiJwtException {
        Class<JwtSourceFactory> clazz = JwtSourceFactory.class;
        synchronized (JwtSourceFactory.class) {
            DefaultJwtSource.JwtSourceOptions jwtSourceOptions = DefaultJwtSource.JwtSourceOptions.builder().spiffeSocketPath(agentSocketAddr).initTimeout(Duration.ofMillis(5000L)).build();
            try {
                jwtSource = DefaultJwtSource.newSource(jwtSourceOptions);
            }
            catch (Throwable e) {
                throw new ZtiJwtException(e);
            }
            agentSocketAddress = agentSocketAddr;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jwtSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() throws ZtiJwtException {
        Class<JwtSourceFactory> clazz = JwtSourceFactory.class;
        synchronized (JwtSourceFactory.class) {
            if (jwtSource == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                jwtSource.close();
            }
            catch (IOException e) {
                throw new ZtiJwtException(e.getMessage());
            }
            jwtSource = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static String getAgentSocketAddress(String agentSocketPath) {
        if (agentSocketPath == null) {
            return defaultAgentSocketAddress;
        }
        if (agentSocketPath.startsWith("unix:")) {
            return agentSocketPath;
        }
        return "unix:" + agentSocketPath;
    }
}

