/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.ztijwthelper;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.JwtSvidException;
import org.byted.security.zti.jwt.shaded.io.spiffe.svid.jwtsvid.JwtSvid;
import org.byted.security.zti.jwt.shaded.org.apache.commons.lang3.StringUtils;
import org.byted.security.ztijwthelper.JwtSourceFactory;
import org.byted.security.ztijwthelper.ZtiJwtException;
import org.byted.security.ztijwthelper.ZtiMetrics;

public class ZTIJwtDaemon
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(ZTIJwtDaemon.class.getName());
    private static final long updateIntervalSecs = 180L;
    private static final String tokenPath = System.getenv("SEC_TOKEN_PATH");
    private static final String tokenStr = System.getenv("SEC_TOKEN_STRING");
    private static String token;
    private static String tokenSource;
    private static String agentSocketPath;
    private static final String[] defaultAgentSocketPaths;
    private static final String agentSocketPathEnv = "ZTI_AGENT_SOCKET_PATH";
    private static final String defaultAudience = "zti";
    private static final String threadNamePrefix = "zti-jwt-helper-thread-";
    public static final String tokenSourceString = "sec_token_string";
    public static final String tokenSourcePath = "sec_token_path";
    public static final String tokenSourceZti = "zti_agent";
    private static volatile ZTIJwtDaemon instance;
    private volatile boolean closed = false;
    private final ScheduledExecutorService pollingExecutorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZTIJwtDaemon getInstance() {
        if (instance != null) return instance;
        Class<ZTIJwtDaemon> clazz = ZTIJwtDaemon.class;
        synchronized (ZTIJwtDaemon.class) {
            if (instance != null) return instance;
            instance = new ZTIJwtDaemon();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ZTIJwtDaemon zTIJwtDaemon = this;
        synchronized (zTIJwtDaemon) {
            if (this.closed) {
                return;
            }
            this.pollingExecutorService.shutdown();
            this.closed = true;
        }
    }

    private ZTIJwtDaemon() {
        this.pollOnce();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t2 = Executors.defaultThreadFactory().newThread(r);
                t2.setDaemon(true);
                t2.setName(ZTIJwtDaemon.threadNamePrefix + t2.getId());
                return t2;
            }
        };
        this.pollingExecutorService = Executors.newScheduledThreadPool(1, threadFactory);
        this.pollingExecutorService.scheduleAtFixedRate(() -> this.pollOnce(), 0L, 180L, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ZTIJwtDaemon.this.close();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollOnce() {
        Class<ZTIJwtDaemon> clazz = ZTIJwtDaemon.class;
        synchronized (ZTIJwtDaemon.class) {
            if (StringUtils.isNotEmpty(tokenStr)) {
                token = tokenStr;
                tokenSource = tokenSourceString;
                ZtiMetrics.emitCounter("get_token_from_string", new String[0]);
            } else if (StringUtils.isNotEmpty(tokenPath)) {
                try {
                    token = new String(Files.readAllBytes(Paths.get(tokenPath, new String[0]))).trim();
                    tokenSource = tokenSourcePath;
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to read token from file, err: " + e.getMessage());
                }
            } else {
                agentSocketPath = this.refreshAgentSocketPath();
                if (new File(agentSocketPath).exists()) {
                    try {
                        JwtSvid jwtSvid = JwtSourceFactory.getJwtSource(agentSocketPath).fetchJwtSvid(defaultAudience, new String[0]);
                        String tokenFromAgent = jwtSvid.getToken().trim();
                        if (StringUtils.isNotEmpty(tokenFromAgent)) {
                            token = tokenFromAgent;
                            tokenSource = tokenSourceZti;
                        }
                    }
                    catch (JwtSvidException | ZtiJwtException e) {
                        ZtiMetrics.emitCounter("get_token_from_agent_fail", new String[0]);
                        LOGGER.log(Level.SEVERE, "fail to fetch token from zti agent, err: " + e.getMessage());
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getToken() {
        return token;
    }

    public String getTokenSource() {
        return tokenSource;
    }

    private String refreshAgentSocketPath() {
        String targetAgentSocketPath = System.getenv(agentSocketPathEnv);
        if (StringUtils.isEmpty(targetAgentSocketPath)) {
            for (String path : defaultAgentSocketPaths) {
                if (!new File(path).exists()) continue;
                targetAgentSocketPath = path;
                break;
            }
        }
        return StringUtils.isNotEmpty(targetAgentSocketPath) ? targetAgentSocketPath : "/var/run/zti-agent/sockets/agent.sock";
    }

    static {
        defaultAgentSocketPaths = new String[]{"/var/run/zti-agent.sock", "/var/run/zti-agent/sockets/agent.sock"};
    }
}

