/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.ztijwthelper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.byted.security.zti.jwt.shaded.io.spiffe.spiffeid.SpiffeId;
import org.byted.security.zti.jwt.shaded.org.apache.commons.lang3.StringUtils;
import org.byted.security.ztijwthelper.LegacyIdentity;
import org.byted.security.ztijwthelper.ZtiJwtException;

public class ZeroTrustIdentity {
    static final String SCHEMA_NS = "ns";
    static final String SCHEMA_REGION = "r";
    static final String SCHEMA_VDC = "vdc";
    static final String SCHEMA_ID = "id";
    static final String NS_USER = "user";
    public SpiffeId SpiffeID;
    public SpiffeId DelegatedSpiffeID;
    public Date Expiry;
    public String Namespace;
    public String Region;
    public String VDC;
    public String ID;
    public LegacyIdentity LegacyID;

    public void validateZTI() throws ZtiJwtException {
        if (this.SpiffeID == null) {
            throw new ZtiJwtException("the SPIFFE ID is the zero value");
        }
        if (this.Expiry == null) {
            throw new ZtiJwtException("the expiry is zero, we do not support zero expiry as token without expiration");
        }
        Map<String, String> spiffeMap = this.parseSpiffeID(this.SpiffeID);
        this.Namespace = spiffeMap.get(SCHEMA_NS);
        this.ID = spiffeMap.get(SCHEMA_ID);
        this.Region = spiffeMap.get(SCHEMA_REGION);
        this.VDC = spiffeMap.get(SCHEMA_VDC);
    }

    public boolean isValidated() {
        return this.ID != null && !this.ID.isEmpty();
    }

    public LegacyIdentity getLegacyID() throws ZtiJwtException {
        if (this.LegacyID != null) {
            return this.LegacyID;
        }
        if (!this.isValidated()) {
            this.validateZTI();
        }
        this.LegacyID = new LegacyIdentity();
        this.LegacyID.Version = 0L;
        this.LegacyID.Authority = this.Namespace;
        this.LegacyID.ExpireTime = this.Expiry.getTime() / 1000L;
        if (StringUtils.equalsIgnoreCase(this.Namespace, NS_USER)) {
            this.LegacyID.PrimaryAuthType = NS_USER;
            this.LegacyID.User = this.ID;
            this.LegacyID.PSM = "";
        } else {
            this.LegacyID.PrimaryAuthType = "PSM";
            this.LegacyID.PSM = this.ID;
            this.LegacyID.User = "";
        }
        if (this.DelegatedSpiffeID != null) {
            Map<String, String> spiffeMap = this.parseSpiffeID(this.DelegatedSpiffeID);
            if (StringUtils.equalsIgnoreCase(spiffeMap.get(SCHEMA_NS), NS_USER)) {
                this.LegacyID.User = StringUtils.isNoneEmpty(this.LegacyID.User) ? this.LegacyID.User : spiffeMap.get(SCHEMA_ID);
            } else {
                this.LegacyID.PSM = StringUtils.isNoneEmpty(this.LegacyID.PSM) ? this.LegacyID.PSM : spiffeMap.get(SCHEMA_ID);
            }
        }
        return this.LegacyID;
    }

    public String toString() {
        return "ZeroTrustIdentity{SpiffeId:" + this.SpiffeID + ", DelegatedSpiffeID:" + this.DelegatedSpiffeID + ", Expiry:'" + this.Expiry + '\'' + ", Namespace:" + this.Namespace + ", Region:'" + this.Region + '\'' + ", VDC:'" + this.VDC + '\'' + ", ID:'" + this.ID + '\'' + ", LegacyID:" + this.LegacyID + '}';
    }

    public Map<String, String> parseSpiffeID(SpiffeId spiffeId) throws ZtiJwtException {
        String[] comps = StringUtils.split(spiffeId.getPath(), "/");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String comp : comps) {
            String[] items = StringUtils.split(comp, ":");
            if (items.length != 2) continue;
            if (result.containsKey(items[0])) {
                throw new ZtiJwtException("duplicate key in spiffe id");
            }
            result.put(items[0], items[1]);
        }
        if (!result.containsKey(SCHEMA_NS) || !result.containsKey(SCHEMA_ID)) {
            throw new ZtiJwtException("the spiffe id is not valid");
        }
        return result;
    }
}

