/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.BitSet;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MutableRoaringArray;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class BufferBitSetUtil {
    private static final int BLOCK_LENGTH = 1024;

    private static MappeableArrayContainer arrayContainerOf(int from2, int to, int cardinality, long[] words) {
        char[] content = new char[cardinality];
        int index = 0;
        int i = from2;
        int socket = 0;
        while (i < to) {
            for (long word = words[i]; word != 0L; word &= word - 1L) {
                content[index++] = (char)(socket + Long.numberOfTrailingZeros(word));
            }
            ++i;
            socket += 64;
        }
        return new MappeableArrayContainer(CharBuffer.wrap(content), cardinality);
    }

    public static MutableRoaringBitmap bitmapOf(BitSet bitSet) {
        return BufferBitSetUtil.bitmapOf(bitSet.toLongArray());
    }

    public static MutableRoaringBitmap bitmapOf(long[] words) {
        MutableRoaringBitmap ans = new MutableRoaringBitmap();
        int containerIndex = 0;
        for (int from2 = 0; from2 < words.length; from2 += 1024) {
            int to = Math.min(from2 + 1024, words.length);
            int blockCardinality = BufferBitSetUtil.cardinality(from2, to, words);
            if (blockCardinality <= 0) continue;
            ((MutableRoaringArray)ans.highLowContainer).insertNewKeyValueAt(containerIndex++, BufferUtil.highbits(from2 * 64), BufferBitSetUtil.containerOf(from2, to, blockCardinality, words));
        }
        return ans;
    }

    private static int cardinality(int from2, int to, long[] words) {
        int sum = 0;
        for (int i = from2; i < to; ++i) {
            sum += Long.bitCount(words[i]);
        }
        return sum;
    }

    private static MappeableContainer containerOf(int from2, int to, int blockCardinality, long[] words) {
        if (blockCardinality <= 4096) {
            return BufferBitSetUtil.arrayContainerOf(from2, to, blockCardinality, words);
        }
        return new MappeableBitmapContainer(LongBuffer.wrap(Arrays.copyOfRange(words, from2, from2 + 1024)), blockCardinality);
    }

    public static boolean equals(BitSet bitset, ImmutableRoaringBitmap bitmap) {
        if (bitset.cardinality() != bitmap.getCardinality()) {
            return false;
        }
        PeekableIntIterator it = bitmap.getIntIterator();
        while (it.hasNext()) {
            int val = it.next();
            if (bitset.get(val)) continue;
            return false;
        }
        return true;
    }
}

