/*
 * Decompiled with CFR 0.152.
 */
package shaded.bytehouse.com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2;

import java.math.BigInteger;
import java.util.NavigableMap;
import shaded.bytehouse.com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.AbstractBigIntegerParser;
import shaded.bytehouse.com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.AbstractNumberParser;
import shaded.bytehouse.com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastDoubleSwar;
import shaded.bytehouse.com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastIntegerMath;
import shaded.bytehouse.com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.ParseDigitsTaskCharArray;

class JavaBigIntegerFromCharArray
extends AbstractBigIntegerParser {
    JavaBigIntegerFromCharArray() {
    }

    public BigInteger parseBigIntegerString(char[] str, int offset, int length, int radix) throws NumberFormatException {
        try {
            boolean isNegative;
            int endIndex = AbstractNumberParser.checkBounds(str.length, offset, length);
            int index = offset;
            char ch = str[index];
            boolean bl = isNegative = ch == '-';
            if ((isNegative || ch == '+') && (ch = JavaBigIntegerFromCharArray.charAt(str, ++index, endIndex)) == '\u0000') {
                throw new NumberFormatException("illegal syntax");
            }
            switch (radix) {
                case 10: {
                    return this.parseDecDigits(str, index, endIndex, isNegative);
                }
                case 16: {
                    return this.parseHexDigits(str, index, endIndex, isNegative);
                }
            }
            return new BigInteger(new String(str, offset, length), radix);
        }
        catch (ArithmeticException e) {
            NumberFormatException nfe = new NumberFormatException("value exceeds limits");
            nfe.initCause(e);
            throw nfe;
        }
    }

    private BigInteger parseDecDigits(char[] str, int from2, int to, boolean isNegative) {
        int numDigits = to - from2;
        if (JavaBigIntegerFromCharArray.hasManyDigits(numDigits)) {
            return this.parseManyDecDigits(str, from2, to, isNegative);
        }
        int preroll = from2 + (numDigits & 7);
        long significand = FastDoubleSwar.tryToParseUpTo7Digits(str, from2, preroll);
        boolean success = significand >= 0L;
        for (from2 = preroll; from2 < to; from2 += 8) {
            int addend = FastDoubleSwar.tryToParseEightDigits(str, from2);
            success &= addend >= 0;
            significand = significand * 100000000L + (long)addend;
        }
        if (!success) {
            throw new NumberFormatException("illegal syntax");
        }
        return BigInteger.valueOf(isNegative ? -significand : significand);
    }

    private BigInteger parseHexDigits(char[] str, int from2, int to, boolean isNegative) {
        int numDigits = to - (from2 = this.skipZeroes(str, from2, to));
        if (numDigits <= 0) {
            return BigInteger.ZERO;
        }
        JavaBigIntegerFromCharArray.checkHexBigIntegerBounds(numDigits);
        byte[] bytes = new byte[(numDigits + 1 >> 1) + 1];
        int index = 1;
        boolean illegalDigits = false;
        if ((numDigits & 1) != 0) {
            char chLow = str[from2++];
            int valueLow = JavaBigIntegerFromCharArray.lookupHex(chLow);
            bytes[index++] = (byte)valueLow;
            illegalDigits = valueLow < 0;
        }
        int prerollLimit = from2 + (to - from2 & 7);
        while (from2 < prerollLimit) {
            char chHigh = str[from2];
            char chLow = str[from2 + 1];
            int valueHigh = JavaBigIntegerFromCharArray.lookupHex(chHigh);
            int valueLow = JavaBigIntegerFromCharArray.lookupHex(chLow);
            bytes[index++] = (byte)(valueHigh << 4 | valueLow);
            illegalDigits |= valueHigh < 0 || valueLow < 0;
            from2 += 2;
        }
        while (from2 < to) {
            long value = FastDoubleSwar.tryToParseEightHexDigits(str, from2);
            FastDoubleSwar.writeIntBE(bytes, index, (int)value);
            illegalDigits |= value < 0L;
            from2 += 8;
            index += 4;
        }
        if (illegalDigits) {
            throw new NumberFormatException("illegal syntax");
        }
        BigInteger result = new BigInteger(bytes);
        return isNegative ? result.negate() : result;
    }

    private BigInteger parseManyDecDigits(char[] str, int from2, int to, boolean isNegative) {
        from2 = this.skipZeroes(str, from2, to);
        int numDigits = to - from2;
        JavaBigIntegerFromCharArray.checkDecBigIntegerBounds(numDigits);
        NavigableMap<Integer, BigInteger> powersOfTen = FastIntegerMath.fillPowersOf10Floor16(from2, to);
        BigInteger result = ParseDigitsTaskCharArray.parseDigitsRecursive(str, from2, to, powersOfTen, 400);
        return isNegative ? result.negate() : result;
    }

    private int skipZeroes(char[] str, int from2, int to) {
        while (from2 < to - 8 && FastDoubleSwar.isEightZeroes(str, from2)) {
            from2 += 8;
        }
        while (from2 < to && str[from2] == '0') {
            ++from2;
        }
        return from2;
    }
}

