/*
 * Decompiled with CFR 0.152.
 */
package shaded.bytehouse.net.openhft.hashing;

import java.nio.ByteOrder;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jetbrains.annotations.NotNull;
import shaded.bytehouse.net.openhft.hashing.Access;
import shaded.bytehouse.net.openhft.hashing.UnsafeAccess;

@ParametersAreNonnullByDefault
public class CompactLatin1CharSequenceAccess
extends Access<byte[]> {
    @NotNull
    static final Access<byte[]> INSTANCE = new CompactLatin1CharSequenceAccess();
    @NotNull
    private static final Access<byte[]> INSTANCE_NON_NATIVE = Access.newDefaultReverseAccess(INSTANCE);
    @NotNull
    private static final UnsafeAccess UNSAFE = UnsafeAccess.INSTANCE;
    private static final long UNSAFE_IDX_ADJUST = UnsafeAccess.BYTE_BASE * 2L + (long)(ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0);
    private static final long ARRAY_IDX_ADJUST = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1L : 0L;

    private CompactLatin1CharSequenceAccess() {
    }

    @Override
    public long getLong(byte[] input, long offset) {
        long byteIdx = offset + UNSAFE_IDX_ADJUST >> 1;
        long compact = UNSAFE.getUnsignedInt(input, byteIdx);
        long expanded = (compact << 16 | compact) & 0xFFFF0000FFFFL;
        expanded = (expanded << 8 | expanded) & 0xFF00FF00FF00FFL;
        if (((int)offset & 1) == 1) {
            return expanded << 8;
        }
        return expanded;
    }

    @Override
    public int getInt(byte[] input, long offset) {
        long byteIdx = offset + UNSAFE_IDX_ADJUST >> 1;
        int compact = UNSAFE.getShort(input, byteIdx) & 0xFFFF;
        int expanded = (compact << 8 | compact) & 0xFF00FF;
        if (((int)offset & 1) == 1) {
            return expanded << 8;
        }
        return expanded;
    }

    @Override
    public long getUnsignedInt(byte[] input, long offset) {
        long byteIdx = offset + UNSAFE_IDX_ADJUST >> 1;
        int compact = UNSAFE.getShort(input, byteIdx) & 0xFFFF;
        long expanded = (compact << 8 | compact) & 0xFF00FF;
        if (((int)offset & 1) == 1) {
            return expanded << 8;
        }
        return expanded;
    }

    @Override
    public int getShort(byte[] input, long offset) {
        if (((int)offset & 1) == 0) {
            int byteIdx = (int)(offset >> 1);
            return input[byteIdx] & 0xFF;
        }
        int byteIdx = (int)(offset + ARRAY_IDX_ADJUST >> 1);
        return input[byteIdx] << 8;
    }

    @Override
    public int getUnsignedShort(byte[] input, long offset) {
        if (((int)offset & 1) == 0) {
            int byteIdx = (int)(offset >> 1);
            return input[byteIdx] & 0xFF;
        }
        int byteIdx = (int)(offset + ARRAY_IDX_ADJUST >> 1);
        return (input[byteIdx] & 0xFF) << 8;
    }

    @Override
    public int getByte(byte[] input, long offset) {
        if (ARRAY_IDX_ADJUST == (long)((int)offset & 1)) {
            return 0;
        }
        return input[(int)(offset >> 1)];
    }

    @Override
    public int getUnsignedByte(byte[] input, long offset) {
        if (ARRAY_IDX_ADJUST == (long)((int)offset & 1)) {
            return 0;
        }
        return input[(int)(offset >> 1)] & 0xFF;
    }

    @Override
    @NotNull
    public ByteOrder byteOrder(byte[] input) {
        return UNSAFE.byteOrder(input);
    }

    @Override
    @NotNull
    protected Access<byte[]> reverseAccess() {
        return INSTANCE_NON_NATIVE;
    }
}

